*-------------------------------------------------------------------------------
*						Table 2
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Tab 2", replace 
set more off     


*-------------------------------------------------------------------------------
*					Step1: Generate Data
*-------------------------------------------------------------------------------
clear
clear all

//empty file for processed data
set obs 0
save tabledata,replace emptyok


foreach j in "2000" "2010" "2015" {
use "`j'census_consistent.dta",clear

gen id_new=_n

gen sector="农" if real(substr(new,1,2))<=5
replace sector="工" if real(substr(new,1,2))>5 & real(substr(new,1,2))<=59
replace sector="服务" if real(substr(new,1,2))>59


collapse (count) id_new,by(consistent title_consistent sector)

egen pop=total(id_new)
gen s_o_share=id_new/pop*100

keep consistent title_consistent sector s_o_share
duplicates drop

gen year =`j'

append using tabledata
save tabledata,replace
}

*-------------------------------------------------------------------------------
*					Step2: Calculation
*-------------------------------------------------------------------------------
*Define different occupations
reshape wide s_o_share,i(consistent title_consistent sector) j(year)

foreach i in "00" "10"{

	foreach j in "10" "15"{
	gen birth`i'`j'= "enter" if s_o_share20`i' ==. & s_o_share20`j' !=. //enter
	replace birth`i'`j'= "exit" if s_o_share20`i' !=. & s_o_share20`j' ==. //exit
	replace birth`i'`j'= "nothing" if s_o_share20`i' ==. & s_o_share20`j' ==. // do not exist
	replace birth`i'`j'= "destruction" if (s_o_share20`i' !=.) & (s_o_share20`j' !=.) & (s_o_share20`i'>s_o_share20`j') // stay-destruction
	replace birth`i'`j'= "creation" if (s_o_share20`i' !=.) & (s_o_share20`j' !=.) & (s_o_share20`i'<s_o_share20`j') // stay-creation

	}
}

drop birth1010

foreach i in "2015" "2010" "2000" {
replace s_o_share`i'=0 if s_o_share`i'==.
}

*initial share
bys sector:egen initial_s0010=total(s_o_share2000)
bys sector:egen initial_s0015=total(s_o_share2000)
bys sector:egen initial_s1015=total(s_o_share2010)

gen d_os0010=s_o_share2010-s_o_share2000
gen d_os0015=s_o_share2015-s_o_share2000
gen d_os1015=s_o_share2015-s_o_share2010

drop s_o_share*

reshape long birth d_os initial_s,i(consistent title_consistent sector) j(type,string)

collapse (sum) d_os,by(sector initial_s type birth)
replace d_os=abs(d_os)

rename type period

bys sector period:egen max=max(d_os)
bys sector period:egen sum=sum(d_os)


reshape wide d_os,i(sector max sum period initial_s) j(birth,string)
rename d_os* *

replace exit=0 if exit==.
gen net=creation+enter-destruction-exit

drop nothing

order sector period creation destruction exit enter net sum max initial_s

gen number =1 if period=="0010"
replace number=2 if period=="1015"
replace number=3 if period=="0015" 
sort sector number
drop number

format creation destruction exit enter net sum max initial_s %7.2f
drop initial_s

list _all

erase tabledata.dta

log close
